'
' This program demonstrates the panning and fading effect using auxiliary
' driver.
'

' $INCLUDE: 'SBC.BI'
' $INCLUDE: 'SBCSYS.BI'
' $INCLUDE: 'SBCVOICE.BI'
' $INCLUDE: 'AUXDRV.BI'

DECLARE   FUNCTION  GETFHANDLE% (filename$)
DECLARE   FUNCTION  OUTVOC% (fh%)
DECLARE   SUB  SHOWERROR ()
DECLARE   SUB  WAITEFFECT ()
DECLARE   SUB  SNDEFFECT ()

CONST     VOCVOL=1


REM $DYNAMIC
CLEAR

DIM   handle AS INTEGER


' Following statements free memory for the loadable drivers.
' You must free sufficient memory for the loadable drivers.
' The free memory must be larger than the driver file size.

' Free 8K memory for the CTVDSK.DRV at the moment
DUMMY = SETMEM(-8192)

' Free 8K memory for the AUXDRV.DRV at the moment
DUMMY = SETMEM(-8192)

' Following statements free memory for the Disk Double Buffer
' Two 32K buffers are released by BASIC
DUMMY = SETMEM(-16400)
DUMMY = SETMEM(-16400)
DUMMY = SETMEM(-16400)
DUMMY = SETMEM(-16400)

CLS

PRINT "SBK Basic Panning and Fading Effect Example"

IF (SBGETENV% = 0) THEN
    IF SBCHKCRD% THEN
        IF SBTSTINT% THEN
            IF SBTSTDMA% >= 0 THEN

                ' Load CTVDSK.DRV
                DSKSEG% = LOADDRV% ("CTVDSK.DRV")

                ' If driver loaded successfully
                IF (DSKSEG% <> 0) THEN
                    ' Set driver address
                    DSKADDX (DSKSEG%)

                    ' Load AUXDRV.DRV
                    AUXSEG% = LOADDRV% ("AUXDRV.DRV")

                    ' If driver loaded successfully
                    IF (AUXSEG% <> 0) THEN
                        ' Set driver address
                        AUXADDX (AUXSEG%)

                        ' Initial the driver,
                        ' with 64K buffer as double buffer
                        IF ( SVDINIT%((16)) = 0 ) THEN

                            handle = GETFHANDLE% ("DEMO1.VOC")

                            IF ( handle <> 0 ) THEN

                                ' Output the voice file
                                IF ( OUTVOC% (handle) ) THEN

                                    ' perform effect
                                    CALL SNDEFFECT
                                ENDIF

                                CALL DOSCLOSE (handle)
                            ENDIF

                            ' Terminate the driver
                            CALL SVDEXIT
                        ELSE
                            CALL SHOWERROR
                        ENDIF

                        ' Release memory allocated for AUXDRV
                        CALL FREEMEM(AUXSEG%)
                    ENDIF

                    ' Release memory allocated for CTVDSK
                    CALL FREEMEM(DSKSEG%)
                ENDIF
            ELSE
                PRINT "Error on DMA channel."
            ENDIF
        ELSE
            PRINT "Error on interrupt."
        ENDIF
    ELSE
        PRINT "Sound Blaster Card not found or wrong I/O setting"
    ENDIF
ELSE
    PRINT "BLASTER environment variable not set or incomplete or invalid."
ENDIF

' Return the memory to BASIC
DUMMY = SETMEM(16400)
DUMMY = SETMEM(16400)
DUMMY = SETMEM(16400)
DUMMY = SETMEM(16400)

DUMMY = SETMEM(8192)
DUMMY = SETMEM(8192)

END


' ------------------------------------------------------------------------ '

FUNCTION LOADDRV% (szDrvName$)

    DIM szDrvFile$, Handle%, dwFileLen&, wDrvSeg%


    LOADDRV% = 0

    ' search SOUND environment for driver
    szDrvFile$ = ENVIRON$("SOUND")

    IF (szDrvFile$ <> "") THEN
        szDrvFile$ = szDrvFile$ + "\DRV\" + szDrvName$

        IF (FINDFILE%(szDrvFile$) = 0) THEN
            szDrvFile$ = ""
        ENDIF
    ENDIF

    ' search the current directory for driver
    IF (szDrvFile$ = "") THEN
        szDrvFile$ = szDrvName$
    ENDIF

    IF (FINDFILE%(szDrvFile$) <> 0) THEN
        Handle% = DOSOPEN%(szDrvFile$)

        IF (Handle% <> 0) THEN
            dwFileLen& = FILESIZE(Handle%)

            wDrvSeg% = ALLOCMEM(INT((dwFileLen& + 15) / 16))

            IF (wDrvSeg% <> 0) THEN
                IF DOSREAD%(Handle%, INT(0), wDrvSeg%, dwFileLen&) THEN
                    LOADDRV% = wDrvSeg%
                ENDIF
            ENDIF

            DOSCLOSE(Handle%)
        ELSE
            PRINT "Error in opening " + szDrvFile$
        ENDIF
    ELSE
        PRINT "Driver file " + szDrvName$ + " does not exist ..."
    ENDIF

END FUNCTION


' ------------------------------------------------------------------------ '


REM %STATIC
FUNCTION  GETFHANDLE% (filename$)

    DIM  retval AS INTEGER


    ' Open the file using DOS function
    retval = DOSOPEN%(filename$)

    IF (retval = 0) THEN
        PRINT "Open " +filename$ + "error."
    ENDIF

    GETFHANDLE% = retval

END FUNCTION


' ------------------------------------------------------------------------ '

REM %STATIC
FUNCTION  OUTVOC% (fh%)

    OUTVOC% = 1

    ' Turn on speaker
    SVDSPKER(INT(1))

    ' Start the output
    IF (SVDOUTPUT%(fh%) <> 0) THEN
        OUTVOC% = 0
        CALL SHOWERROR
    ENDIF

END FUNCTION


' ------------------------------------------------------------------------ '

SUB WAITEFFECT

    DIM  userkey AS INTEGER, dummy AS INTEGER


    WHILE ( CTFADE% OR CTPAN% )
        ' Stop effect if no voice process
        IF CTVOICE% = 0 THEN
            dummy = AXSTOP
        ENDIF

        c$ = INKEY$

        IF c$ <> "" THEN
            userkey = INT(ASC(LEFT$(c$, 1)))

            SELECT CASE userkey
                CASE ASC("S"), ASC("s"), 27
                    dummy = AXSTOP
                    CALL SVDSTOP
                CASE ASC("P"), ASC("p")
                    dummy = AXPAUSE
                    CALL SVDPAUSE
                CASE ASC("C"), ASC("c")
                    dummy = AXSTART
                    CALL SVDCONT
            END SELECT
        END IF
    WEND

END SUB


' ------------------------------------------------------------------------ '

SUB SNDEFFECT

    DIM  wPrevVol AS INTEGER, dummy AS INTEGER


    CALL AXINIT

    ' preserve previous volume status
    wPrevVol = AXGETVOL% (VOCVOL)

    ' set voice left/right volume to 0
    dummy = AXSETVOL% (VOCVOL,0)

    ' setup voice volume fading in mode 0
    dummy = AXFADE% (VOCVOL, &HF0F0, 5000, 0, 0)
    dummy = AXSTART%
    CALL WAITEFFECT

    ' setup digitized sound for panning in mode 1
    ' and repeat for 5 times
    dummy = AXPAN% (VOCVOL, 0, 255, 600, 1, 5)
    dummy = AXSTART%
    CALL WAITEFFECT

    ' set voice left/right volume to &HF0F0
    dummy = AXSETVOL% (VOCVOL,&HF0F0)

    ' setup voice volume fading in mode 0
    dummy = AXFADE% (VOCVOL, 0, 5000, 0, 0)
    dummy = AXSTART%
    CALL WAITEFFECT

    ' set voice left/right volume back to previous status
    dummy = AXSETVOL% (VOCVOL,wPrevVol)

    CALL AXEXIT

END SUB


' ------------------------------------------------------------------------ '

SUB  SHOWERROR

' This function show the error code from the driver

    DIM  errcode AS INTEGER

    errcode = SVDDRVERR%

    PRINT "Driver error ="; errcode

    errcode = SVDEXTERR%

    IF (errcode <> 0) THEN
       PRINT "Dos error ="; errcode
    ENDIF

END SUB

